package ru.yandex.webmaster3.core.download;

import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ifilippov5 on 20.02.17.
 */
public class SearchUrlStatusUtil {
    static private Map<SearchUrlStatusEnum, String> statusViewMap = new HashMap<>();
    static {
        statusViewMap.put(SearchUrlStatusEnum.INDEXED_SEARCHABLE, "SEARCHABLE");
        statusViewMap.put(SearchUrlStatusEnum.SEMIDUP, "DUPLICATE");
        statusViewMap.put(SearchUrlStatusEnum.SR, "LOW_DEMAND");
        statusViewMap.put(SearchUrlStatusEnum.PARSER_ERROR, "PARSE_ERROR");
        statusViewMap.put(SearchUrlStatusEnum.ROBOTS_URL_ERROR, "ROBOTS_TXT_ERROR");
        statusViewMap.put(SearchUrlStatusEnum.NOTHING_FOUND, "UNKNOWN_URL");
        statusViewMap.put(SearchUrlStatusEnum.NO_INDEX, "META_NO_INDEX");
    }

    public static String getStatusView(SearchUrlStatusEnum status) {
        if (statusViewMap.containsKey(status))
            return statusViewMap.get(status);
        return status.toString();
    }
}
