package ru.yandex.webmaster3.core.download.searchquery;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.xcelite.sheet.XceliteSheet;
import ru.yandex.webmaster3.core.xcelite.writer.SheetWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.xcelite.NotLeakingXcelite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by ifilippov5 on 06.03.17.
 */
public class ExcelWriter implements AbstractWriter {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriter.class);
    private NotLeakingXcelite xcelite;
    private SheetWriter writer;
    private Collection<List<Object>> coll;

    public ExcelWriter() {
        xcelite = new NotLeakingXcelite();
        XceliteSheet sheet = xcelite.createSheet("sheet1");
        writer = sheet.getSimpleWriter();
        coll = new ArrayList<>();
    }

    @Override
    public void write(List<Object> line) {
        coll.add(line.stream().map(value -> value == null ? "" : value).collect(Collectors.toList()));
        //writer.write(line);
    }

    @Override
    public byte[] getBytes() {
        writer.write(coll);
        try {
            return xcelite.getBytes();
        } catch (IOException e) {
            throw new WebmasterException("Unable to serialize to xslx",
                    new WebmasterErrorResponse.ExportErrorResponse(getClass(), e));
        }
    }

    @Override
    public void close() {
    }
}