package ru.yandex.webmaster3.core.events2;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class HostEvent {
    private final String reqId;
    private final Instant date;
    private final UUID taskId;
    private final Long userId;
    private final Long adminUserId;
    private final WebmasterHostId hostId;
    private final HostEventData data;

    public HostEvent(
            @JsonProperty("reqId") String reqId,
            @JsonProperty("date") Instant date,
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("userId") Long userId,
            @JsonProperty("adminUserId") Long adminUserId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("data") HostEventData data) {
        this.reqId = reqId;
        this.date = date;
        this.taskId = taskId;
        this.userId = userId;
        this.adminUserId = adminUserId;
        this.hostId = hostId;
        this.data = data;
    }

    public String getReqId() {
        return reqId;
    }

    public UUID getTaskId() {
        return taskId;
    }

    public Long getUserId() {
        return userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public HostEventData getData() {
        return data;
    }

    public HostEventType getType() {
        return data.getType();
    }

    public Instant getDate() {
        return date;
    }

    public Long getAdminUserId() {
        return adminUserId;
    }

    public static HostEvent create(HostEventId id, WebmasterHostId hostId, HostEventData data) {
        return new HostEvent(id.getReqId(), Instant.now(), id.getTaskId(), id.getUserId(), id.getAdminUserId(), hostId, data);
    }
}
