package ru.yandex.webmaster3.core.events2;

import ru.yandex.webmaster3.core.http.request.RequestId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class HostEventId {
    private final String reqId;
    private final UUID taskId;
    private final Long userId;
    private final Long adminUserId;

    private HostEventId(String reqId, UUID taskId, Long userId, Long adminUserId) {
        this.reqId = reqId;
        this.taskId = taskId;
        this.userId = userId;
        this.adminUserId = adminUserId;
    }

    public String getReqId() {
        return reqId;
    }

    public UUID getTaskId() {
        return taskId;
    }

    public Long getUserId() {
        return userId;
    }

    public Long getAdminUserId() {
        return adminUserId;
    }

    public static HostEventId createFromTaskId(UUID taskId) {
        return new HostEventId(null, taskId, null, null);
    }

    public static HostEventId createFromUserRequest(RequestId requestId, long userId) {
        return new HostEventId(requestId.toString(), null, userId, null);
    }

    public static HostEventId createFromAdminRequest(RequestId requestId, long adminUserId) {
        return new HostEventId(requestId.toString(), null, null, adminUserId);
    }

    public static HostEventId createFromCoordinatorRequest(String requestId) {
        return new HostEventId(requestId, null, null, null);
    }
}
