package ru.yandex.webmaster3.core.events2;

import ru.yandex.webmaster3.core.http.autodoc.OrderBy;

/**
 * @author avhaliullin
 */
@OrderBy("getSuperType")
@OrderBy("ordinal")
public enum HostEventMetaType {
    SITEMAP(null),
    USER_SITEMAP(SITEMAP),
    USER_TOOLS(null),
    RECHECK(null),
    USER_HOST(null),
    ;

    private final HostEventMetaType superType;

    HostEventMetaType(HostEventMetaType superType) {
        this.superType = superType;
    }

    public HostEventMetaType getSuperType() {
        return superType;
    }
}
