package ru.yandex.webmaster3.core.events2;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.events2.events.HostGenerationUpdatedEvent;
import ru.yandex.webmaster3.core.events2.events.LinksStatisticsReceivedEvent;
import ru.yandex.webmaster3.core.events2.events.SanctionsGenerationUpdatedEvent;
import ru.yandex.webmaster3.core.events2.events.SecurityWarningStateUpdatedEvent;
import ru.yandex.webmaster3.core.events2.events.SiteStructureReceivedEvent;
import ru.yandex.webmaster3.core.events2.events.recheck.InfectionRecheckRequestedEvent;
import ru.yandex.webmaster3.core.events2.events.recheck.SanctionsRecheckRequestedEvent;
import ru.yandex.webmaster3.core.events2.events.recheck.SiteProblemRecheckRequested;
import ru.yandex.webmaster3.core.events2.events.sitemap.AddUserSitemapEvent;
import ru.yandex.webmaster3.core.events2.events.sitemap.DeleteUserSitemapEvent;
import ru.yandex.webmaster3.core.events2.events.sitemap.UpdateSitemapGenerationEvent;
import ru.yandex.webmaster3.core.events2.events.tools.CheckUrlRequestedEvent;
import ru.yandex.webmaster3.core.events2.events.tools.MobileAuditForUrlRequestedEvent;
import ru.yandex.webmaster3.core.events2.events.userhost.UserHostAddedEvent;
import ru.yandex.webmaster3.core.events2.events.userhost.UserHostDeletedEvent;
import ru.yandex.webmaster3.core.http.autodoc.OrderBy;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * @author avhaliullin
 */
@OrderBy("getMetaType")
@OrderBy("name")
public enum HostEventType implements IntEnum, Discriminator<HostEventData> {
    USER_SITEMAP_ADD(0, HostEventMetaType.USER_SITEMAP, AddUserSitemapEvent.class),
    USER_SITEMAP_DELETE(1, HostEventMetaType.USER_SITEMAP, DeleteUserSitemapEvent.class),
    HOST_GENERATION_UPDATED(2, null, HostGenerationUpdatedEvent.class),
    SITEMAPS_GENERATION_UPDATED(3, HostEventMetaType.SITEMAP, UpdateSitemapGenerationEvent.class),
    SITE_STRUCTURE_RECEIVED(4, null, SiteStructureReceivedEvent.class),
    SECURITY_WARNING_STATE_UPDATED(5, null, SecurityWarningStateUpdatedEvent.class),
    LINKS_STATISTICS_RECEIVED(6, null, LinksStatisticsReceivedEvent.class),
    CHECK_URL_REQUESTED(7, HostEventMetaType.USER_TOOLS, CheckUrlRequestedEvent.class),
    MOBILE_AUDIT_FOR_URL_REQUESTED(8, HostEventMetaType.USER_TOOLS, MobileAuditForUrlRequestedEvent.class),
    INFECTION_RECHECK_REQUESTED(9, HostEventMetaType.RECHECK, InfectionRecheckRequestedEvent.class),
    SITE_PROBLEM_RECHECK_REQUESTED(10, HostEventMetaType.RECHECK, SiteProblemRecheckRequested.class),
    SANCTIONS_RECHECK_REQUESTED(11, HostEventMetaType.RECHECK, SanctionsRecheckRequestedEvent.class),
    SANCTIONS_GENERATION_UPDATED(12, null, SanctionsGenerationUpdatedEvent.class),
    USER_HOST_ADDED(13, HostEventMetaType.USER_HOST, UserHostAddedEvent.class),
    USER_HOST_DELETED(14, HostEventMetaType.USER_HOST, UserHostDeletedEvent.class),
    ;

    private final int value;
    private final HostEventMetaType metaType;
    private final Class<? extends HostEventData> dataClass;

    HostEventType(int value, HostEventMetaType metaType, @NotNull Class<? extends HostEventData> dataClass) {
        this.value = value;
        this.metaType = metaType;
        this.dataClass = dataClass;
    }

    @Override
    public int value() {
        return value;
    }

    public Class<? extends HostEventData> getDataClass() {
        return dataClass;
    }

    public HostEventMetaType getMetaType() {
        return metaType;
    }

    public static final IntEnumResolver<HostEventType> R = IntEnumResolver.r(HostEventType.class);
}
