package ru.yandex.webmaster3.core.events2.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.HostEventJsonUtils;

/**
 * @author avhaliullin
 */
public abstract class AbstractHostEventLogClient implements HostEventLogClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractHostEventLogClient.class);

    private final int attempts;

    protected AbstractHostEventLogClient(int attempts) {
        this.attempts = attempts;
    }

    protected abstract void doLog(HostEvent event) throws Exception;

    @Override
    public void log(HostEvent event) {
        boolean success = false;
        int attemptsLeft = this.attempts;
        while (attemptsLeft > 0 && !success) {
            try {
                doLog(event);
                success = true;
            } catch (Exception e) {
                log.warn("Failed to write event, attempts left {}", --attemptsLeft, e);
            }
        }
        if (!success) {
            log.error("Dropping event - {}", HostEventJsonUtils.serializeEvent(event));
        }
    }
}
