package ru.yandex.webmaster3.core.events2.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class HostGenerationUpdatedEvent extends HostEventData {
    private final UUID generationId;

    @JsonCreator
    public HostGenerationUpdatedEvent(UUID generationId) {
        super(HostEventType.HOST_GENERATION_UPDATED);
        this.generationId = generationId;
    }

    public UUID getGenerationId() {
        return generationId;
    }
}
