package ru.yandex.webmaster3.core.events2.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class LinksStatisticsReceivedEvent extends HostEventData {
    private final UUID generationId;
    private final Instant collectionDate;

    public LinksStatisticsReceivedEvent(
            @JsonProperty("generationId") UUID generationId,
            @JsonProperty("collectionDate") Instant collectionDate
    ) {
        super(HostEventType.LINKS_STATISTICS_RECEIVED);
        this.generationId = generationId;
        this.collectionDate = collectionDate;
    }

    public Instant getCollectionDate() {
        return collectionDate;
    }

    public UUID getGenerationId() {
        return generationId;
    }
}
