package ru.yandex.webmaster3.core.events2.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SanctionsGenerationUpdatedEvent extends HostEventData {
    private final UUID generationId;
    private final boolean haveSanctions;

    public SanctionsGenerationUpdatedEvent(
            @JsonProperty("generationId") UUID generationId,
            @JsonProperty("haveSanctions") boolean haveSanctions
    ) {
        super(HostEventType.SANCTIONS_GENERATION_UPDATED);
        this.generationId = generationId;
        this.haveSanctions = haveSanctions;
    }

    public UUID getGenerationId() {
        return generationId;
    }

    public boolean isHaveSanctions() {
        return haveSanctions;
    }
}
