package ru.yandex.webmaster3.core.events2.events;

import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SiteStructureReceivedEvent extends HostEventData {
    private final UUID structureId;
    private final Instant collectionDate;

    public SiteStructureReceivedEvent(
            @JsonProperty("structureId") UUID structureId,
            @JsonProperty("collectionDate") Instant collectionDate
    ) {
        super(HostEventType.SITE_STRUCTURE_RECEIVED);
        this.structureId = structureId;
        if (collectionDate == null) {
            this.collectionDate = new Instant(UUIDs.unixTimestamp(structureId));
        } else {
            this.collectionDate = collectionDate;
        }
    }

    public UUID getStructureId() {
        return structureId;
    }

    public Instant getCollectionDate() {
        return collectionDate;
    }
}
