package ru.yandex.webmaster3.core.events2.events.recheck;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class InfectionRecheckRequestedEvent extends HostEventData {
    private final UUID generationId;

    public InfectionRecheckRequestedEvent(@JsonProperty("generationId") UUID generationId) {
        super(HostEventType.INFECTION_RECHECK_REQUESTED);
        this.generationId = generationId;
    }

    @Description("id поколения вирусов")
    public UUID getGenerationId() {
        return generationId;
    }
}
