package ru.yandex.webmaster3.core.events2.events.recheck;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

/**
 * @author avhaliullin
 */
public class SiteProblemRecheckRequested extends HostEventData {
    private final SiteProblemTypeEnum problemType;

    public SiteProblemRecheckRequested(@JsonProperty("problemType") SiteProblemTypeEnum problemType) {
        super(HostEventType.SITE_PROBLEM_RECHECK_REQUESTED);
        this.problemType = problemType;
    }

    public SiteProblemTypeEnum getProblemType() {
        return problemType;
    }
}
