package ru.yandex.webmaster3.core.events2.events.sitemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class AddUserSitemapEvent extends HostEventData {
    private final String sitemapUrl;
    private final UUID sitemapId;

    public AddUserSitemapEvent(
            @JsonProperty("sitemapUrl") String sitemapUrl,
            @JsonProperty("sitemapId") UUID sitemapId
    ) {
        super(HostEventType.USER_SITEMAP_ADD);
        this.sitemapUrl = sitemapUrl;
        this.sitemapId = sitemapId;
    }

    public UUID getSitemapId() {
        return sitemapId;
    }

    public String getSitemapUrl() {
        return sitemapUrl;
    }
}
