package ru.yandex.webmaster3.core.events2.events.sitemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class UpdateSitemapGenerationEvent extends HostEventData {
    private final UUID generationId;
    public UpdateSitemapGenerationEvent(@JsonProperty("generationId") UUID generationId) {
        super(HostEventType.SITEMAPS_GENERATION_UPDATED);
        this.generationId = generationId;
    }

    public UUID getGenerationId() {
        return generationId;
    }
}
