package ru.yandex.webmaster3.core.events2.events.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class CheckUrlRequestedEvent extends HostEventData {
    private final String url;
    private final UUID taskId;

    public CheckUrlRequestedEvent(
            @JsonProperty("url") String url,
            @JsonProperty("taskId") UUID taskId
    ) {
        super(HostEventType.CHECK_URL_REQUESTED);
        this.url = url;
        this.taskId = taskId;
    }

    public String getUrl() {
        return url;
    }

    public UUID getTaskId() {
        return taskId;
    }
}
