package ru.yandex.webmaster3.core.events2.events.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventType;

import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class MobileAuditForUrlRequestedEvent extends HostEventData {
    private final URL url;
    private final UUID taskId;

    public MobileAuditForUrlRequestedEvent(
            @JsonProperty("url") URL url,
            @JsonProperty("taskId") UUID taskId
    ) {
        super(HostEventType.MOBILE_AUDIT_FOR_URL_REQUESTED);
        this.url = url;
        this.taskId = taskId;
    }

    public URL getUrl() {
        return url;
    }

    public UUID getTaskId() {
        return taskId;
    }
}
