package ru.yandex.webmaster3.core.feedback;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;

/**
 * @author: ishalaru
 * DATE: 03.06.2019
 */
public class Feedback {
    private final String hostId;
    private final Long userId;
    private final DateTime createDate;
    private final FeedbackType type;
    private final String message;
    private final String meta;

    public Feedback(@JsonProperty("hostId") String hostId,
                    @JsonProperty("userId") Long userId,
                    @JsonProperty("createDate") DateTime createDate,
                    @JsonProperty("type") FeedbackType type,
                    @JsonProperty("message") String message,
                    @JsonProperty("meta") String meta) {
        this.hostId = hostId;
        this.userId = userId;
        this.createDate = createDate;
        this.type = type;
        this.message = message;
        this.meta = meta;
    }

    public String getHostId() {
        return hostId;
    }

    public Long getUserId() {
        return userId;
    }

    public DateTime getCreateDate() {
        return createDate;
    }

    public FeedbackType getType() {
        return type;
    }

    public String getMessage() {
        return message;
    }

    public String getMeta() {
        return meta;
    }
}
