package ru.yandex.webmaster3.core.feedback;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author: ishalaru
 * DATE: 02.06.2019
 */
@AllArgsConstructor
@Getter
public enum FeedbackType implements IntEnum {
    AUTOPARSER_OFF(0, true),
    AUTOMORDA_OFF(1, true),
    AUTORELATED_OFF(2, true),
    CHATS_OFF(3, true),
    TURBO_DESKTOP_OFF(4, true),
    TURBO_YML_OFF(5, true),
    TURBO_PAYMENTS_OFF(6, true),
    TURBO_LISTINGS_OFF(7, true),
    TURBO_CART_OFF(8, true),
    TURBO_SUPPORT_QUERY(9, true),
    MARKET_DELIVERY_OFF(10, true),
    CRAWL_METRIKA_DISABLED(11, false),
    METRIKA_BINDING_REMOVE(12, false),
    NOTIFICATIONS_OFF(13, false),
    ;

    private final int value;
    private final boolean isTurbo;


    @Override
    public int value() {
        return this.value;
    }

    public static final IntEnumResolver<FeedbackType> R = IntEnumResolver.r(FeedbackType.class);

}
