package ru.yandex.webmaster3.core.feedback;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

/**
 * @author: ishalaru
 * DATE: 01.07.2019
 */
public class SendFeedbackEMailTaskData extends WorkerTaskData {
    private Long userId;
    private String message;
    private String meta;
    private FeedbackType feedbackType;

    public SendFeedbackEMailTaskData(@JsonProperty("hostId") WebmasterHostId hostId,
                                     @JsonProperty("userId") Long userId,
                                     @JsonProperty("message") String message,
                                     @JsonProperty("meta") String meta,
                                     @JsonProperty("feedbackType") FeedbackType feedbackType) {
        super(hostId);
        this.userId = userId;
        this.message = message;
        this.meta = meta;
        this.feedbackType = feedbackType;
    }

    public FeedbackType getFeedbackType() {
        return feedbackType;
    }

    public Long getUserId() {
        return userId;
    }

    public String getMessage() {
        return message;
    }

    public String getMeta() {
        return meta;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.SEND_FEEDBACK_EMAIL;
    }

    @Override
    public String getShortDescription() {
        return "Send feedback email notification to support.";
    }

    @Override
    public String toString() {
        return "SendFeedbackEMailTaskData{" +
                "userId=" + userId +
                ", message='" + message + '\'' +
                ", meta='" + meta + '\'' +
                ", feedbackType=" + feedbackType +
                '}';
    }
}
