package ru.yandex.webmaster3.core.feeds.feed;

import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@AllArgsConstructor
public enum ExternalFeedType implements IntEnum {
    MARKET(0, true),
    DIRECT(1, true),
    TURBO(2, true),
    ANNOUNCEMENT(3, false),
    ;
    int value;
    boolean isVerticalShare;

    @Override
    public int value() {
        return value;
    }
    public static final IntEnumResolver<ExternalFeedType> R = IntEnumResolver.r(ExternalFeedType.class);
}
