package ru.yandex.webmaster3.core.feeds.feed;

import java.util.Set;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@AllArgsConstructor
public enum FeedServiceType implements IntEnum {
    SEARCH(0),
    MARKET(1),
    ANNOUNCEMENT(2),
    ;
    int value;

    @Override
    public int value() {
        return value;
    }
    public static final IntEnumResolver<FeedServiceType> R = IntEnumResolver.r(FeedServiceType.class);
    public static final TypeReference<Set<FeedServiceType>> SET_R = new TypeReference<>() {};

}
