package ru.yandex.webmaster3.core.feeds.feed;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Created by Oleg Bazdyrev on 20/01/2022.
 */
@Getter
@AllArgsConstructor
public enum FeedsErrorSeverity {
    SUCCESS("success", 0),
    INFO("info", 1),
    FATAL("fatal", 3),
    WARNING("warning", 2),
    ;


    private final String code;
    private final int order;
    private static final Map<String, FeedsErrorSeverity> VALUES_BY_CODE = new HashMap<>();
    static {
        for (FeedsErrorSeverity value : values()) {
            VALUES_BY_CODE.put(value.code, value);
        }
    }

    @JsonCreator
    public static FeedsErrorSeverity byCode(String code) {
        return VALUES_BY_CODE.get(code);
    }

    public boolean isGood() {
        return this == SUCCESS;
    }

    public boolean isBad() {
        return this == WARNING || this == FATAL;
    }

    public static final EnumResolver<FeedsErrorSeverity> R = EnumResolver.er(FeedsErrorSeverity.class);
    public static final Comparator<FeedsErrorSeverity> BY_ORDER = Comparator.comparing(FeedsErrorSeverity::getOrder);
}
