package ru.yandex.webmaster3.core.feeds.feed;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 2/25/22
 */

@AllArgsConstructor
public enum FeedsOfferBanTypeEnum implements IntEnum {
    @JsonEnumDefaultValue
    UNKNOWN(0, "Не определено"),
    OUT_OF_STOCK(1, "Товара нет в наличии"),
    PRICE_PROBLEM(2, "Неправильная цена"),
    BAD_URL(3, "Страница товара недоступна"),
    BAD_OFFER_NAME(4, "Ошибка в названии товара"),
    DISTANCE_SELLING_PROHIBITED(5, "Товар запрещено продавать дистанционно"),
    FORBIDDEN_WORD(6, "В составе предложения присутствует запрещенное слово"),
    WRONG_GOOD_INFO(7, "Недостоверная информация о товаре"),
    LEGAL(8, "Товар скрыт по запросу правообладателя"),
    ;

    private final int value;
    @Getter
    private final String description;

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<FeedsOfferBanTypeEnum> R = IntEnumResolver.r(FeedsOfferBanTypeEnum.class);
}
