package ru.yandex.webmaster3.core.feeds.feed;

import com.fasterxml.jackson.annotation.JsonCreator;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 20/01/2022.
 */
public enum FeedsQualityErrorEnum {
    @Description("Неизвестная (еще не поддерживаемая ошибка) - пользователю не показывать")
    Unknown,
    @Description("У оффера нет сетов и картинок")
    NoSetsAndImages,
    @Description("Нет цены и текста")
    NoPriceAndText,
    @Description("Урлы оффера и сета совпадают")
    OfferAndSetSameUrl,
    @Description("Оффер не подходит для табличного формата")
    OfferUnusableForTableView,
    @Description("Нет картинки")
    NoImage,
    @Description("Загруженная картинка уже есть у другого оффера")
    DuplicateImage,
    @Description("Сет является кокнретным предложением, но у него есть под-сеты")
    CertainOfferHasSubsets,
    @Description("Сет является подсетом, но у него есть конкретные предложения")
    SubsetHasConcreteOffers,
    @Description("Слишком низкая цена")
    TooLowPrice,
    @Description("У сета слишком мало офферов")
    TooFewOffersForSet,
    @Description("Нет построенного предложения")
    NoBuiltOffer,
    @Description("Нет параметра image")
    EmptyImageParam,
    @Description("Нет параметра name")
    EmptyNameParam,
    @Description("Нет параметра url")
    EmptyUrlParam,
    @Description("Отсутствует цена")
    EmptyPrice,
    @Description("Нет построенной строки для таблицы")
    NoBuiltRowForTableView,
    @Description("Не указана широта или долгота")
    NotLatOrLon,
    @Description("Слишком мало картинок для сета")
    TooFewImagesForSet,
    @Description("Отсутствуют параметры 'годы опыта', 'description' и 'регион'")
    NoExpDesReg,
    @Description("Нет ни одного из параметров 'phone_url', 'chat_url', 'order_url'")
    NoPhonChatOrd,
    @Description("Имя в оффере дублируется")
    DupOfferName,
    @Description("Отсутствует параметр 'Конверсия'")
    NoConversion,
    @Description("Параметр 'Конверсия' меньше 0")
    NegativeConversion,
    @Description("Слишком много картинкок")
    TooManyImages,
    @Description("Минимальная зарплата слишком маленькая")
    TooLowMinSalary,
    @Description("Максимальная зарплата слишком маленькая")
    TooLowMaxSalary,
    @Description("Минимальная зарплата слишком большая")
    TooBigMinSalary,
    @Description("Максимальная зарплата слишком большая")
    TooBigMaxSalary,
    @Description("Неизвестная валюта")
    UnknownCurrency,
    @Description("У оффера длолжен быть либо список сетов, либо параметр 'Число объявлений'")
    NoSetsAndAdvCount,
    @Description("У офферов одинаковые урлы")
    DuplicateOfferUrls,
    NoConversion_Param,
    NoAddressParam,
    NoLatitudeParam,
    NoLongitudeParam,
    NoObjectTypeParam,
    NoOrgIdParam,
    NoRouteUrlParam,
    NoWorkHoursParam,
    ParamConversionIsNotNumber,
    ParamLatitudeIsNotNumber,
    ParamLongitudeIsNotNumber,
    ParamRatingIsNotNumber,
    ParamReviewsCountIsNotNumber,
    ParamPriceRatingIsNotNumber,
    ParamStarRatingIsNotNumber,
    ParamMetroDistanceIsNotNumber,
    InvalidTimezone,
    InvalidDate,
    ;

    @JsonCreator
    public static FeedsQualityErrorEnum byCode(String code) {
        try {
            return FeedsQualityErrorEnum.valueOf(code);
        } catch (IllegalArgumentException e) {
            return Unknown;
        }
    }
}
