package ru.yandex.webmaster3.core.feeds.feed;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * Created by Oleg Bazdyrev on 20/01/2022.
 */
@AllArgsConstructor
public enum FeedsValidationErrorEnum {
    Unknown(""),
    Banned_Feed("Banned.Feed"),
    Document_BadDomain("Document.BadDomain"),
    Document_BadDomain_NotAllowed("Document.BadDomain.NotAllowed"),
    Document_QuotaExceeded_Images("Document.QuotaExceeded.Images"),
    Document_Related_BadDomain_NotAllowed("Document.Related.BadDomain.NotAllowed"),
    Duplicate_Document("Duplicate.Document"),
    Duplicate_Feed("Duplicate.Feed"),
    Email_BadDomain("Email.BadDomain"),
    Email_BadDomain_Invalid("Email.BadDomain.Invalid"),
    Email_BadDomain_NotAllowed("Email.BadDomain.NotAllowed"),
    Email_InvalidFormat("Email.InvalidFormat"),
    Fetch_Internal("Fetch.Internal"),
    Fetch_QuotaExceeded_Feeds("Fetch.QuotaExceeded.Feeds"),
    Fetch_QuotaExceeded_Images("Fetch.QuotaExceeded.Images"),
    Fetch_QuotaExceeded_Items("Fetch.QuotaExceeded.Items"),
    Fetch_Skip("Fetch.Skip"),
    Images_FetchError("Images.FetchError"),
    Images_Internal("Images.Internal"),
    Images_StillWaiting("Images.StillWaiting"),
    Internal_Error("Internal.Error"),
    Parser_Ad_BadId("Parser.Ad.BadId"),
    Parser_Ad_BadType("Parser.Ad.BadType"),
    Parser_Ad_Duplicate("Parser.Ad.Duplicate"),
    Parser_Ad_MissingTurboId("Parser.Ad.MissingTurboId"),
    Parser_Ad_UnknownRef("Parser.Ad.UnknownRef"),
    Parser_Ad_UnknownType("Parser.Ad.UnknownType"),
    Parser_BadFormat("Parser.BadFormat"),
    Parser_BadFormat_BrokenUtf("Parser.BadFormat.BrokenUtf"),
    Parser_BadFormat_DuplicateTag("Parser.BadFormat.DuplicateTag"),
    Parser_BadFormat_MissingTag("Parser.BadFormat.MissingTag"),
    Parser_BadFormat_NoText("Parser.BadFormat.NoText"),
    Parser_BadFormat_TextTooLong("Parser.BadFormat.TextTooLong"),
    Parser_BadFormat_UnexpectedTag("Parser.BadFormat.UnexpectedTag"),
    Parser_BadFormat_UnknownParentCategory("Parser.BadFormat.UnknownParentCategory"),
    Parser_BadLogo("Parser.BadLogo"),
    Parser_DuplicateUrls("Parser.DuplicateUrls"),
    Parser_EmptyXml("Parser.EmptyXml"),
    Parser_Goal_BadId("Parser.Goal.BadId"),
    Parser_Goal_Duplicate("Parser.Goal.Duplicate"),
    Parser_Goal_NoAttr("Parser.Goal.NoAttr"),
    Parser_Goal_UnknownType("Parser.Goal.UnknownType"),
    Parser_Http3xx("Parser.Http3xx"),
    Parser_Http4xx("Parser.Http4xx"),
    Parser_Http5xx("Parser.Http5xx"),
    Parser_Internal("Parser.Internal"),
    Parser_Item_BadEnclosure("Parser.Item.BadEnclosure"),
    Parser_Item_BadPdaUrl("Parser.Item.BadPdaUrl"),
    Parser_Item_BadPubDate("Parser.Item.BadPubDate"),
    Parser_Item_BadRelated("Parser.Item.BadRelated"),
    Parser_Item_BadSource("Parser.Item.BadSource"),
    Parser_Item_BadTitle("Parser.Item.BadTitle"),
    Parser_Item_BadUrl("Parser.Item.BadUrl"),
    Parser_Item_HtmlTagsInText("Parser.Item.HtmlTagsInText"),
    Parser_Item_InvalidCoverMarkup("Parser.Item.InvalidCoverMarkup"),
    Parser_Item_InvalidTurboMarkup("Parser.Item.InvalidTurboMarkup"),
    Parser_Item_NonTurbo("Parser.Item.NonTurbo"),
    Parser_Item_NotAllGroupAttributesSpecified("Parser.Item.NotAllGroupAttributesSpecified"),
    Parser_Item_NoText("Parser.Item.NoText"),
    Parser_Item_NoUrl("Parser.Item.NoUrl"),
    Parser_Item_TooManyRelatedItems("Parser.Item.TooManyRelatedItems"),
    Parser_Item_TurboContent_BadSocial("Parser.Item.TurboContent.BadSocial"),
    Parser_Item_TurboContent_ContentRequired("Parser.Item.TurboContent.ContentRequired"),
    Parser_Item_TurboContent_ContradictingAttributes("Parser.Item.TurboContent.ContradictingAttributes"),
    Parser_Item_TurboContent_CustomHtmlInvalidClassAttr("Parser.Item.TurboContent.CustomHtmlInvalidClassAttr"),
    Parser_Item_TurboContent_CustomHtmlInvalidIdAttr("Parser.Item.TurboContent.CustomHtmlInvalidIdAttr "),
    Parser_Item_TurboContent_DuplicateElementId("Parser.Item.TurboContent.DuplicateElementId"),
    Parser_Item_TurboContent_DuplicateOnPageWidgetFeedback("Parser.Item.TurboContent.DuplicateOnPageWidgetFeedback"),
    Parser_Item_TurboContent_FoldBlockWithUnsupportedTag("Parser.Item.TurboContent.FoldBlockWithUnsupportedTag"),
    Parser_Item_TurboContent_HtmlTagsInText("Parser.Item.TurboContent.HtmlTagsInText"),
    Parser_Item_TurboContent_InvalidHtmlClosingTag("Parser.Item.TurboContent.InvalidHtmlClosingTag"),
    Parser_Item_TurboContent_InvalidUrl("Parser.Item.TurboContent.InvalidUrl"),
    Parser_Item_TurboContent_InvalidUrlFragment("Parser.Item.TurboContent.InvalidUrlFragment"),
    Parser_Item_TurboContent_InvalidValue("Parser.Item.TurboContent.InvalidValue"),
    Parser_Item_TurboContent_LargePage("Parser.Item.TurboContent.LargePage"),
    Parser_Item_TurboContent_MarketWidgetWithSelector("Parser.Item.TurboContent.MarketWidgetWithSelector"),
    Parser_Item_TurboContent_MultipleCallButtonInWidgetFeedback("Parser.Item.TurboContent.MultipleCallButtonInWidgetFeedback"),
    Parser_Item_TurboContent_NoCards("Parser.Item.TurboContent.NoCards"),
    Parser_Item_TurboContent_NoItems("Parser.Item.TurboContent.NoItems"),
    Parser_Item_TurboContent_NoItemsInCarousel("Parser.Item.TurboContent.NoItemsInCarousel"),
    Parser_Item_TurboContent_NoItemsInCollection("Parser.Item.TurboContent.NoItemsInCollection"),
    Parser_Item_TurboContent_NoItemsInHistogram("Parser.Item.TurboContent.NoItemsInHistogram"),
    Parser_Item_TurboContent_NoItemsInTabs("Parser.Item.TurboContent.NoItemsInTabs"),
    Parser_Item_TurboContent_NoItemsInWidgetFeedback("Parser.Item.TurboContent.NoItemsInWidgetFeedback"),
    Parser_Item_TurboContent_NoRequiredAttr("Parser.Item.TurboContent.NoRequiredAttr"),
    Parser_Item_TurboContent_NoTextAndIcon("Parser.Item.TurboContent.NoTextAndIcon"),
    Parser_Item_TurboContent_NoValidSocial("Parser.Item.TurboContent.NoValidSocial"),
    Parser_Item_TurboContent_RecursionDepthLimitReached("Parser.Item.TurboContent.RecursionDepthLimitReached"),
    Parser_Item_TurboContent_RequiredOneOfAttrs("Parser.Item.TurboContent.RequiredOneOfAttrs"),
    Parser_Item_TurboContent_SelfConstructedTurboUrl("Parser.Item.TurboContent.SelfConstructedTurboUrl"),
    Parser_Item_TurboContent_UnknownCardType("Parser.Item.TurboContent.UnknownCardType"),
    Parser_Item_TurboContent_UnknownCarouselItemType("Parser.Item.TurboContent.UnknownCarouselItemType"),
    Parser_Item_TurboContent_UnknownIcon("Parser.Item.TurboContent.UnknownIcon"),
    Parser_Item_TurboContent_UnknownWidgetFeedbackType("Parser.Item.TurboContent.UnknownWidgetFeedbackType"),
    Parser_Item_TurboContent_UnsupportedTag("Parser.Item.TurboContent.UnsupportedTag"),
    Parser_Item_TurboContent_WallOfText("Parser.Item.TurboContent.WallOfText"),
    Parser_NoChannel("Parser.NoChannel"),
    Parser_NoItems("Parser.NoItems"),
    Parser_NotRss("Parser.NotRss"),
    Parser_NotYml("Parser.NotYml"),
    Parser_TooBigSize("Parser.TooBigSize"),
    Parser_Tracker_BadId("Parser.Tracker.BadId"),
    Parser_Tracker_Duplicate("Parser.Tracker.Duplicate"),
    Parser_Tracker_InvalidJson("Parser.Tracker.InvalidJson"),
    Parser_Tracker_UnknownType("Parser.Tracker.UnknownType"),
    Parser_XmlError("Parser.XmlError"),
    Skip_Images("Skip.Images"),
    Storage_Internal("Storage.Internal"),
    // ======= Goods ========
    // Categories
    Goods_CategoryIdTooLong("Goods.330"),
    Goods_CategoryIdDuplicates("Goods.331"),
    Goods_CategoryNameTooLong("Goods.332"),
    Goods_CategoryNameDuplicates("Goods.333"),
    Goods_CategoryCycle("Goods.530"),
    Goods_CategoryNameEmpty("Goods.531"),
    Goods_CategoryIdNotANumber("Goods.532"),
    // Currency
    Goods_CurrencyUnknown("Goods.340"),
    Goods_CurrencyDuplicates("Goods.342"),
    Goods_CurrencyWrongRate("Goods.343"),
    // Feed
    Goods_FeedBadShopUrl("Goods.360"),
    Goods_FeedInvalidShopTag("Goods.363"),
    Goods_FeedInvalidDate("Goods.36F"),
    Goods_FeedInvalidTagValue("Goods.464"),
    // Xml
    Goods_XmlUnknownTag("Goods.421"),
    Goods_XmlParsingError("Goods.521"),
    Goods_XmlInvalidSymbol("Goods.523"),
    Goods_XmlInvalidNonPrintableSymbol("Goods.524"),
    // Csv
    Goods_CsvBadRowFormat("Goods.472"),
    Goods_CsvInvalidHeader("Goods.570"),
    // Checker
    Goods_CheckedDownloadError("Goods.50E"),
    // Offer
    Goods_OfferTooManyDeclined("Goods.550"),
    Goods_OfferValidNotFound("Goods.551"),

    ;
    @Getter
    private final String code;
    private static final Map<String, FeedsValidationErrorEnum> VALUES_BY_CODE = new HashMap<>();
    static {
        for (FeedsValidationErrorEnum value : values()) {
            VALUES_BY_CODE.put(value.code, value);
        }
    }

    @JsonCreator
    public static FeedsValidationErrorEnum byCode(String code) {
        return VALUES_BY_CODE.getOrDefault(code, Unknown);
    }
}
