package ru.yandex.webmaster3.core.feeds.feed;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.With;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/**
 * @author kravchenko99
 * @date 7/30/21
 */
@Value
@Builder(toBuilder = true)
@With
@AllArgsConstructor
public class NativeFeedInfo2 {
    String domain;
    String url;
    @Nullable
    Long userId;
    List<Integer> regionsId;
    String login;
    String password;
    NativeFeedStatus status;
    List<String> errors;
    NativeFeedSccStatus statusScc;
    List<String> errorsScc;
    NativeFeedType type;
    Set<FeedServiceType> enabledServiceTypes;
    DateTime addDate;
    DateTime updateDate;
    boolean enabled;


    Long businessId;
    Long partnerId;
    Long feedId;

    DateTime sccTimestamp;
    List<Map<String, Object>> errorsOfferBase;
    NativeFeedStatus statusVertical;
    DateTime sccFinishTimestamp;

    public NativeFeedInfo2(String domain, String url, Long userId, List<Integer> regionsId, String login,
                           String password, NativeFeedStatus status, List<String> errors,
                           NativeFeedSccStatus statusScc, List<String> errorsScc, NativeFeedType type,
                           Set<FeedServiceType> enabledServiceTypes, DateTime addDate, DateTime updateDate,
                           boolean enabled, Long businessId, Long partnerId, Long feedId, DateTime sccTimestamp,
                           List<Map<String, Object>> errorsOfferBase, DateTime sccFinishTimestamp) {
        this.domain = domain;
        this.url = url;
        this.userId = userId;
        this.regionsId = regionsId;
        this.login = login;
        this.password = password;
        this.status = status;
        this.errors = errors;
        this.statusScc = statusScc;
        this.errorsScc = errorsScc;
        this.type = type;
        this.enabledServiceTypes = enabledServiceTypes;
        this.addDate = addDate;
        this.updateDate = updateDate;
        this.enabled = enabled;
        this.businessId = businessId;
        this.partnerId = partnerId;
        this.feedId = feedId;
        this.sccTimestamp = sccTimestamp;
        this.errorsOfferBase = errorsOfferBase;
        this.statusVertical = NativeFeedStatus.SUCCESS;
        this.sccFinishTimestamp = sccFinishTimestamp;
    }

    public static NativeFeedInfo2 ofMbi(String domain, String url, long userId, List<Integer> regionsId, String login, String password,
                                        NativeFeedStatus status, List<String> errors, NativeFeedSccStatus statusScc,
                                        List<String> errorsScc, NativeFeedType type, Set<FeedServiceType> enabledServiceTypes,
                                        DateTime addDate, DateTime updateDate, boolean enabled, Long businessId, Long partnerId,
                                        Long feedId, NativeFeedStatus statusVertical) {
        return new NativeFeedInfo2(
                domain,
                url,
                userId,
                regionsId,
                login,
                password,
                status,
                errors,
                statusScc,
                errorsScc,
                type,
                enabledServiceTypes,
                addDate,
                updateDate,
                enabled,
                businessId,
                partnerId,
                feedId,
                null,
                Collections.emptyList(),
                statusVertical,
                null

        );
    }
    public static NativeFeedInfo2 ofUs(String domain, String url, long userId, List<Integer> regionsId, String login, String password,
                                       NativeFeedStatus status, List<String> errors, NativeFeedSccStatus statusScc,
                                       List<String> errorsScc, NativeFeedType type, Set<FeedServiceType> enabledServiceTypes,
                                       DateTime addDate, DateTime updateDate, boolean enabled, DateTime sccTimestamp,
                                       NativeFeedStatus statusVertical) {
        return new NativeFeedInfo2(
                domain,
                url,
                userId,
                regionsId,
                login,
                password,
                status,
                errors,
                statusScc,
                errorsScc,
                type,
                enabledServiceTypes,
                addDate,
                updateDate,
                enabled,
                null,
                null,
                null,
                sccTimestamp,
                Collections.emptyList(),
                statusVertical,
                null
        );
    }

    public boolean isMbiFeed() {
        return partnerId != null;
    }

    public NativeFeedInfo2 toUrlWithUserInfo() {
        if (getPassword() == null && getLogin() == null) {
            return this.toBuilder().build();
        }
        String userInfo = getLogin();
        if (getPassword() != null) {
            userInfo += ":" + getPassword();
        }
        try {
            URL url = new URL(getUrl());
            URI uri = new URI(url.getProtocol(), userInfo, url.getHost(), url.getPort(), url.getPath(),
                    url.getQuery(), url.getRef());
            return this.toBuilder().url(uri.toString()).build();

        } catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isGoodsFeed() {
        return getType() == NativeFeedType.STORES;
    }

    public boolean isNotGoodsFeed() {
        return !isGoodsFeed();
    }

}
