package ru.yandex.webmaster3.core.feeds.feed;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@AllArgsConstructor
@Getter
public enum NativeFeedSccStatus implements IntEnum {
    UNKNOWN(0, "checking", true),
    IN_PROGRESS(1, "checking", true),
    SUCCESS(2, "published", false),
    FAILED(3, "rejected", true),
    BANNED(4, "rejected", true),
    DISABLED_BY_PINGER(5, "rejected", true),
    ;
    int value;
    String status;
    boolean moderation;

    @Override
    public int value() {
        return value;
    }
    public static final IntEnumResolver<NativeFeedSccStatus> R = IntEnumResolver.r(NativeFeedSccStatus.class);
}
