package ru.yandex.webmaster3.core.feeds.feed;

import java.util.Arrays;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.util.W3Collectors;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@Getter
@AllArgsConstructor
public enum NativeFeedStatus implements IntEnum {
    SUCCESS(0, "ok", FeedsErrorSeverity.SUCCESS),
    FAILED(1, "error", FeedsErrorSeverity.FATAL),
    IN_PROGRESS(2, "in_progress", FeedsErrorSeverity.INFO),
    WARNING(3, "warning", FeedsErrorSeverity.WARNING),
    ;
    int value;
    String status;
    FeedsErrorSeverity severity;

    @Override
    public int value() {
        return value;
    }
    public static final IntEnumResolver<NativeFeedStatus> R = IntEnumResolver.r(NativeFeedStatus.class);
    public static final Map<String, NativeFeedStatus> S = Arrays.stream(NativeFeedStatus.values()).map(x -> Pair.of(x.status, x)).collect(W3Collectors.toHashMap());
}
