package ru.yandex.webmaster3.core.feeds.feed;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@AllArgsConstructor
public enum NativeFeedType implements IntEnum {
    //недвижимость
    REALTY(0, "realty"),
    //работа
    VACANCY(1, "vacancies"),
    //врачи
    DOCTORS(2, "doctors"),
    //авто
    CARS(3, "cars"),
    //магазины
    STORES(4, "goods"),
    //услуги
    SERVICES(5, "services"),
    //образование
    EDUCATION(6, "education"),
    //гео
    GEOORG(7, "geoorg"),

    ;
    int value;
    @Getter
    String typeOfferBase;

    @Override
    public int value() {
        return value;
    }
    public static final IntEnumResolver<NativeFeedType> R = IntEnumResolver.r(NativeFeedType.class);
    public static final Map<String, NativeFeedType> OFFER_BASE_TYPE_TO_ENUM = Arrays.stream(values())
            .collect(Collectors.toMap(NativeFeedType::getTypeOfferBase, Function.identity()));

    public static NativeFeedType fromCode(String code) {
        return OFFER_BASE_TYPE_TO_ENUM.get(code);
    }


}
