package ru.yandex.webmaster3.core.feeds.feed_domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.With;
import org.joda.time.DateTime;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@Value
@With
@Builder(toBuilder = true)
@AllArgsConstructor
public class FeedDomainInfo {
    String domain;
    Long businessId;
    FeedDomainSccStatus status;
    DateTime startSccTimestamp;
    DateTime finishSccTimestamp;
    String errorScc;

    public static FeedDomainInfo of(String domain, long businessId) {
        return new FeedDomainInfo(domain, businessId, FeedDomainSccStatus.UNKNOWN, null, null, null);
    }

    public static FeedDomainInfo empty(String domain) {
        return new FeedDomainInfo(domain, null, FeedDomainSccStatus.UNKNOWN, null, null, null);
    }
}
