package ru.yandex.webmaster3.core.feeds.feed_domain;

import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 7/30/21
 */

@AllArgsConstructor
public enum FeedDomainSccStatus implements IntEnum {
    UNKNOWN(0),
    IN_PROGRESS(1),
    SUCCESS(2),
    FAILED(3),
    BANNED(4),
    ;
    final int value;

    @Override
    public int value() {
        return value;
    }
    public static final IntEnumResolver<FeedDomainSccStatus> R = IntEnumResolver.r(FeedDomainSccStatus.class);
}
