package ru.yandex.webmaster3.core.host;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;

/**
 * @author avhaliullin
 */
public class RobotsTxtExportInfo {
    private final boolean robotsTxtLoaded;
    private final String hostDirective;
    private final boolean hasErrors;
    private final boolean hasWarnings;
    private final String hostDirective2NdLevel;
    private final boolean hostDirective2ndLevelFoundInDb;

    public RobotsTxtExportInfo(String hostDirective, boolean robotsTxtLoaded, boolean hasErrors,
                               boolean hasWarnings, String hostDirective2NdLevel, boolean hostDirective2ndLevelFoundInDb) {
        this.robotsTxtLoaded = robotsTxtLoaded;
        this.hostDirective = Strings.emptyToNull(hostDirective);
        this.hasErrors = hasErrors;
        this.hasWarnings = hasWarnings;
        this.hostDirective2NdLevel = Strings.emptyToNull(hostDirective2NdLevel);
        this.hostDirective2ndLevelFoundInDb = hostDirective2ndLevelFoundInDb;
    }

    public String getHostDirective() {
        return hostDirective;
    }

    public boolean isHasErrors() {
        return hasErrors;
    }

    public boolean isHasWarnings() {
        return hasWarnings;
    }

    public boolean isRobotsTxtLoaded() {
        return robotsTxtLoaded;
    }

    public String getHostDirective2NdLevel() {
        return hostDirective2NdLevel;
    }

    public boolean isHostDirective2ndLevelFoundInDb() {
        return hostDirective2ndLevelFoundInDb;
    }
}
