package ru.yandex.webmaster3.core.host;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

@Value
@JsonIgnoreProperties(ignoreUnknown = true)
public class SlowUrlSampleInfo {
    String path;
    Long lastAccess;
    Long fetchTime;

    @JsonCreator
    public SlowUrlSampleInfo(@JsonProperty("path") String path,
                             @JsonProperty("lastAccess") Long lastAccess,
                             @JsonProperty("fetchTime") Long fetchTime) {
        this.path = path;
        this.lastAccess = lastAccess;
        this.fetchTime = fetchTime;
    }
}
