package ru.yandex.webmaster3.core.host;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 25.03.15
 * Time: 17:35
 */
public enum UnsafeHostStateEnum implements IntEnum {
    UNSAFE(0),
    CLEAR(1);

    private final int id;

    UnsafeHostStateEnum(int id) {
        this.id = id;
    }

    @Override
    public int value() {
        return id;
    }

    public static IntEnumResolver<UnsafeHostStateEnum> R = IntEnumResolver.r(UnsafeHostStateEnum.class);
}
