package ru.yandex.webmaster3.core.host.service;

import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

/**
 * Created by Oleg Bazdyrev on 21/11/2018.
 */
@Slf4j
public class HostCanonizer {
    /**
     * Получение обычного оунера по хоста
     *
     * @param host
     * @return
     */
    public static native String getHostOwner(String host);

    /**
     * Получение маскотного оунера по хосту
     *
     * @param host
     * @return
     */
    public static native String getMascotHostOwner(String host);

    /**
     * Получение обычного оунера по урлу
     *
     * @param host
     * @return
     */
    public static native String getUrlOwner(String host);

    /**
     * Получение маскотного оунера по урлу
     *
     * @param host
     * @return
     */
    public static native String getMascotUrlOwner(String host);

    // Чьобы было можно мокать при тестировании
    public static class HostCanonizerWrapper {
        public String getHostOwner(String host) {
            return HostCanonizer.getHostOwner(host);
        }

        public String getMascotHostOwner(String host) {
            return HostCanonizer.getMascotHostOwner(host);
        }

        public String getUrlOwner(String host) {
            return HostCanonizer.getUrlOwner(host);
        }

        public String getMascotUrlOwner(String host) {
            return HostCanonizer.getMascotUrlOwner(host);
        }
    }
}
