package ru.yandex.webmaster3.core.host.verification;

import java.util.Optional;
import java.util.UUID;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface IUserHostVerifier {
    /**
     * Произвести проверку
     *
     * @param userId
     * @param hostId
     * @param recordId
     * @param verificationUin
     * @return Optional.empty(), если проверка пройдена, Optional.of(информация_об_ошибке) иначе
     */
    Optional<VerificationFailInfo> verify(long userId, WebmasterHostId hostId, UUID recordId, long verificationUin, VerificationCausedBy verificationCausedBy);

    /**
     * Применима ли данная проверка для этого хоста (например, whois неприменим для зоны .ru на данный момент)
     *
     * @param hostId
     * @param userId
     * @return
     */
    boolean isApplicable(WebmasterHostId hostId, long userId);


    /**
     * Вызывается перед запуском процесса подтверждения хоста.
     * Представляет собой смесь проверки входных условий и подготовки к подтверждению.
     * В отличие от {@link IUserHostVerifier#isApplicable(WebmasterHostId, long)}, может быть мутирующим.
     *
     * @return true, если процесс подтверждения успешно запустился
     */
    default boolean beforeVerification(WebmasterHostId hostId, long userId) {
        return true;
    }
}
