package ru.yandex.webmaster3.core.host.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 16.06.17.
 */
public enum VerificationCausedBy implements IntEnum {
    @Description("первоначальная инициированная самим пользователем")
    INITIAL_VERIFICATION(0),
    @Description("регулярная")
    REGULAR_RECHECK(1),
    @Description("по запросу")
    RESET_REQUESTED(2),
    @Description("при помощи внутреннего API (внутри Яндекса)")
    INTERNAL_API(3),
    ;
    private final int value;

    VerificationCausedBy(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<VerificationCausedBy> R = IntEnumResolver.r(VerificationCausedBy.class);
}
