package ru.yandex.webmaster3.core.host.verification;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.host.verification.fail.AutoVerificationCancelledFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.DNSRecordNotFoundFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.DelegationCancelledFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.FakeVerificationCancelled;
import ru.yandex.webmaster3.core.host.verification.fail.IDMVerificationCancelledFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.MetaTagNotFoundFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.NotApplicableFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.PDDEmuVerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.PDDVerificationCancelledFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.PageUnavailableFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.SelfVerificationCancelled;
import ru.yandex.webmaster3.core.host.verification.fail.TxtVerificationNotSupportedFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.VerifiedEmailsNotFoundInWhoisFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.WrongHtmlPageContentFailInfo;
import ru.yandex.webmaster3.core.http.autodoc.OrderBy;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * @author avhaliullin
 */
@OrderBy("verificationType")
public enum VerificationFailEnum implements IntEnum, Discriminator<VerificationFailInfo> {
    META_TAG_NOT_FOUND(0, VerificationType.META_TAG, MetaTagNotFoundFailInfo.class),
    PAGE_UNAVAILABLE(1, null, PageUnavailableFailInfo.class),
    WRONG_HTML_PAGE_CONTENT(2, VerificationType.HTML_FILE, WrongHtmlPageContentFailInfo.class),
    DNS_RECORD_NOT_FOUND(3, VerificationType.DNS, DNSRecordNotFoundFailInfo.class),
    NOT_APPLICABLE_FAIL_INFO(4, null, NotApplicableFailInfo.class),
    WHOIS_EMAIL_NOT_FOUND(5, VerificationType.WHOIS, VerifiedEmailsNotFoundInWhoisFailInfo.class),
    DELEGATION_CANCELLED(6, VerificationType.DELEGATED, DelegationCancelledFailInfo.class),
    SELF_VERIFICATION_CANCELLED(7, VerificationType.SELF, SelfVerificationCancelled.class),
    PDD_VERIFICATION_CANCELLED(8, VerificationType.PDD, PDDVerificationCancelledFailInfo.class),
    AUTO_VERIFICATION_CANCELLED(9, VerificationType.AUTO, AutoVerificationCancelledFailInfo.class),
    TXT_VERIFICATION_NOT_SUPPORTED(10, null, TxtVerificationNotSupportedFailInfo.class),
    IDM_VERIFICATION_CANCELLED(11, VerificationType.IDM, IDMVerificationCancelledFailInfo.class),
    PDD_EMU_FAIL_INFO(13, VerificationType.PDD_EMU, PDDEmuVerificationFailInfo.class),
    FAKE_VERIFICATION_CANCELLED(14, VerificationType.FAKE, FakeVerificationCancelled.class),
    ;

    private final int value;
    private final Class<? extends VerificationFailInfo> dataClass;
    public final VerificationType verificationType;

    VerificationFailEnum(int value, VerificationType verificationType, Class<? extends VerificationFailInfo> dataClass) {
        this.value = value;
        this.dataClass = dataClass;
        this.verificationType = verificationType;
    }

    @Override
    public int value() {
        return value;
    }

    @Override
    public Class<? extends VerificationFailInfo> getDataClass() {
        return dataClass;
    }
}
