package ru.yandex.webmaster3.core.host.verification;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WebmasterJsonModule;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public class VerificationFailInfoJsonUtils {
    private static final ObjectMapper OM = new ObjectMapper()
            .disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)
            .registerModule(new JodaModule())
            .registerModule(new WebmasterJsonModule(false));

    public static VerificationFailInfo deserialize(String json) {
        if (json == null) {
            return null;
        }
        try {
            return OM.readValue(json, VerificationFailInfo.class);
        } catch (IOException | RuntimeException e) {
            throw new WebmasterException("Failed to parse verification info from " + json,
                    new WebmasterErrorResponse.InternalUnknownErrorResponse(VerificationFailInfoJsonUtils.class, null), e);
        }
    }

    public static String serialize(VerificationFailInfo info) {
        if (info == null) {
            return null;
        }
        try {
            return OM.writeValueAsString(info);
        } catch (JsonProcessingException e) {
            throw new WebmasterException("Failed to serialize verification fail info",
                    new WebmasterErrorResponse.InternalUnknownErrorResponse(VerificationFailInfoJsonUtils.class, null), e);
        }
    }
}
