package ru.yandex.webmaster3.core.host.verification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum VerificationStatus implements IntEnum {
    @Description("подтверждено")
    VERIFIED(0),
    @Description("подтверждение в процессе")
    IN_PROGRESS(1),
    @Description("права не подтверждены")
    VERIFICATION_FAILED(2),
    @Description("не удалось подтвердить из-за внутренней ошибки")
    INTERNAL_ERROR(3),
    ;
    private final int value;

    VerificationStatus(int value) {
        this.value = value;
    }


    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<VerificationStatus> R = IntEnumResolver.r(VerificationStatus.class);
}
