package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @author avhaliullin
 */
public class DNSRecord {
    private final String name;
    private final String type;
    private final String dclass;
    private final long ttl;
    private final String data;

    public DNSRecord(
            @JsonProperty("name") String name,
            @JsonProperty("type") String type,
            @JsonProperty("dclass") String dclass,
            @JsonProperty("ttl") long ttl,
            @JsonProperty("data") String data
    ) {
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
        this.data = data;
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public String getDclass() {
        return dclass;
    }

    public long getTtl() {
        return ttl;
    }

    public String getData() {
        return data;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
