package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;

import java.util.List;

/**
 * @author avhaliullin
 */
public class DNSRecordNotFoundFailInfo extends VerificationFailInfo {
    private final boolean hostFoundInDNS;
    private final List<DNSRecord> foundTxtRecords;
    private final List<DNSRecord> foundYandexVerificationRecords;

    public DNSRecordNotFoundFailInfo(
            @JsonProperty("hostNotFoundInDNS") boolean hostFoundInDNS,
            @JsonProperty("foundTxtRecords") List<DNSRecord> foundTxtRecords,
            @JsonProperty("foundYandexVerificationRecords") List<DNSRecord> foundYandexVerificationRecords
    ) {
        super(VerificationFailEnum.DNS_RECORD_NOT_FOUND);
        this.hostFoundInDNS = hostFoundInDNS;
        this.foundTxtRecords = foundTxtRecords;
        this.foundYandexVerificationRecords = foundYandexVerificationRecords;
    }

    public List<DNSRecord> getFoundTxtRecords() {
        return foundTxtRecords;
    }

    public List<DNSRecord> getFoundYandexVerificationRecords() {
        return foundYandexVerificationRecords;
    }

    @Description("false, если dns ответил, что хост не найден")
    public boolean isHostFoundInDNS() {
        return hostFoundInDNS;
    }
}
