package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;

/**
 * @author avhaliullin
 */
@Description("Делегирование прав было отменено")
public class DelegationCancelledFailInfo extends VerificationFailInfo {
    private final Long cancelledByUser;
    private final DateTime cancelledDate;

    public DelegationCancelledFailInfo(
            @JsonProperty("cancelledByUser") Long cancelledByUser,
            @JsonProperty("cancelledDate") DateTime cancelledDate
    ) {
        super(VerificationFailEnum.DELEGATION_CANCELLED);
        this.cancelledByUser = cancelledByUser;
        this.cancelledDate = cancelledDate;
    }

    @Description("Кто отменил. Может быть null, если мы не знаем, кто")
    public Long getCancelledByUser() {
        return cancelledByUser;
    }

    @Description("Когда отменили. Может быть null, если мы не знаем, когда")
    public DateTime getCancelledDate() {
        return cancelledDate;
    }
}
