package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.VerificationHttpResponseInfo;

import java.util.List;

/**
 * @author avhaliullin
 */
public class MetaTagNotFoundFailInfo extends VerificationFailInfo {
    private final List<String> metaTags;
    private final List<String> yandexVerificationTags;
    private final VerificationHttpResponseInfo response;

    public MetaTagNotFoundFailInfo(
            @JsonProperty("metaTags") List<String> metaTags,
            @JsonProperty("yandexVerificationTags") List<String> yandexVerificationTags,
            @JsonProperty("response") VerificationHttpResponseInfo response) {
        super(VerificationFailEnum.META_TAG_NOT_FOUND);
        this.metaTags = metaTags;
        this.yandexVerificationTags = yandexVerificationTags;
        this.response = response;
    }

    @Description("найденные метатеги")
    public List<String> getMetaTags() {
        return metaTags;
    }

    @Description("найденные теги яндексовой верификации с неподходящим ключом")
    public List<String> getYandexVerificationTags() {
        return yandexVerificationTags;
    }

    @Description("ответ сервера")
    public VerificationHttpResponseInfo getResponse() {
        return response;
    }

}
