package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.PageUnavailableReason;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.VerificationHttpResponseInfo;

import java.net.URL;
import java.util.List;

/**
 * @author leonidrom
 */
public class PDDEmuVerificationFailInfo extends VerificationFailInfo {
    private final DNSRecordCNAMENotFoundFailInfo dnsRecordCNAMENotFoundFailInfo;
    private final VerificationFailInfo pageUnavailableFailInfo;

    public PDDEmuVerificationFailInfo(
            @JsonProperty("dnsRecordCNAMENotFoundFailInfo") DNSRecordCNAMENotFoundFailInfo dnsRecordCNAMENotFoundFailInfo,
            @JsonProperty("pageUnavailableFailInfo") VerificationFailInfo pageUnavailableFailInfo) {
        super(VerificationFailEnum.PDD_EMU_FAIL_INFO);
        this.dnsRecordCNAMENotFoundFailInfo = dnsRecordCNAMENotFoundFailInfo;
        this.pageUnavailableFailInfo = pageUnavailableFailInfo;
    }

    @Description("Причина ошибки поверки через CNAME")
    public DNSRecordCNAMENotFoundFailInfo getDnsRecordCNAMENotFoundFailInfo() {
        return dnsRecordCNAMENotFoundFailInfo;
    }

    @Description("Причина ошибки поверки через html файл")
    public VerificationFailInfo getPageUnavailableFailInfo() {
        return pageUnavailableFailInfo;
    }

    public static class DNSRecordCNAMENotFoundFailInfo {
        private final boolean hostFoundInDNS;
        private final List<DNSRecord> foundCnameRecords;

        public DNSRecordCNAMENotFoundFailInfo(
                @JsonProperty("hostNotFoundInDNS") boolean hostFoundInDNS,
                @JsonProperty("foundCnameRecords") List<DNSRecord> foundCnameRecords
        ) {
            this.hostFoundInDNS = hostFoundInDNS;
            this.foundCnameRecords = foundCnameRecords;
        }

        public List<DNSRecord> getFoundCnameRecords() {
            return foundCnameRecords;
        }

        @Description("false, если dns ответил, что хост не найден")
        public boolean isHostFoundInDNS() {
            return hostFoundInDNS;
        }
    }
}
