package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.PageUnavailableReason;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.VerificationHttpResponseInfo;

import java.net.URL;

/**
 * @author avhaliullin
 */
public class PageUnavailableFailInfo extends VerificationFailInfo {
    private final URL url;
    private final VerificationHttpResponseInfo response;
    private final PageUnavailableReason reason;

    public PageUnavailableFailInfo(
            @JsonProperty("url") URL url,
            @JsonProperty("response") VerificationHttpResponseInfo response,
            @JsonProperty("reason") PageUnavailableReason reason) {
        super(VerificationFailEnum.PAGE_UNAVAILABLE);
        this.url = url;
        this.response = response;
        this.reason = reason;
    }

    @Description("урл документа, который не удалось скачать в ходе проверки")
    public URL getUrl() {
        return url;
    }

    @Description("ответ сервера")
    public VerificationHttpResponseInfo getResponse() {
        return response;
    }

    @Description("причина недоступности страницы")
    public PageUnavailableReason getReason() {
        return reason;
    }
}
