package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class VerifiedEmailsNotFoundInWhoisFailInfo extends VerificationFailInfo {
    private final Set<String> verifiedEmails;
    private final Set<String> addedNotVerifiedEmails;
    private final Set<String> emailsFoundInWhois;

    public VerifiedEmailsNotFoundInWhoisFailInfo(
            @JsonProperty("verifiedEmails") Set<String> verifiedEmails,
            @JsonProperty("addedNotVerifiedEmails") Set<String> addedNotVerifiedEmails,
            @JsonProperty("emailsFoundInWhois") Set<String> emailsFoundInWhois
    ) {
        super(VerificationFailEnum.WHOIS_EMAIL_NOT_FOUND);
        this.verifiedEmails = verifiedEmails;
        this.addedNotVerifiedEmails = addedNotVerifiedEmails;
        this.emailsFoundInWhois = emailsFoundInWhois;
    }

    @Description("email'ы, подтвержденные пользователем в паспорте")
    public Set<String> getVerifiedEmails() {
        return verifiedEmails;
    }

    @Description("email'ы, найденные в whois")
    public Set<String> getEmailsFoundInWhois() {
        return emailsFoundInWhois;
    }

    @Description("email'ы, добавленные в паспорт, но не подтвержденные")
    public Set<String> getAddedNotVerifiedEmails() {
        return addedNotVerifiedEmails;
    }
}
