package ru.yandex.webmaster3.core.host.verification.fail;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.host.verification.VerificationFailEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.VerificationHttpResponseInfo;

/**
 * @author avhaliullin
 */
public class WrongHtmlPageContentFailInfo extends VerificationFailInfo {
    private final VerificationHttpResponseInfo response;

    public WrongHtmlPageContentFailInfo(
            @JsonProperty("response") VerificationHttpResponseInfo response
    ) {
        super(VerificationFailEnum.WRONG_HTML_PAGE_CONTENT);
        this.response = response;
    }

    public VerificationHttpResponseInfo getResponse() {
        return response;
    }
}
