package ru.yandex.webmaster3.core.hoststat;

import java.util.Comparator;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * Created by Oleg Bazdyrev on 12/03/2021.
 */
@Value
@Builder
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class HostStatistics {
    WebmasterHostId hostId;
    long docs;
    long docsOnSearch;
    long htmlDocs;
    long goodDocsOnSearch;
    long emptyTitles;
    long emptyDescriptions;
    long slowPages;
    long pagesWithFetchTime;
    long totalFetchTime;
    long uniqueTitles;
    long uniqueDescriptions;
    long duplicateTitles;
    long duplicateDescriptions;
    PageSample mordaSample;
    List<PageSample> slowPageSamples;
    List<PageSample> emptyTitleSamples;
    List<PageSample> emptyDescriptionSamples;
    List<ContentAttrSample> prevailingTitles;
    List<ContentAttrSample> prevailingDescriptions;
    List<PageSample> duplicatePageSamples;

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class PageSample {
        public static final TypeReference<PageSample> REFERENCE = new TypeReference<>() {
        };
        public static final TypeReference<List<PageSample>> LIST_REFERENCE = new TypeReference<>() {
        };
        @JsonProperty("Path")
        String path;
        @JsonProperty("FetchTime")
        Long fetchTime;
        @JsonProperty("LastAccess")
        Long lastAccess;
        @JsonProperty("HttpCode")
        Integer httpCode;
        @JsonProperty("MainUrl")
        String mainUrl;

        public static final Comparator<PageSample> BY_LAST_ACCESS_DESC = Comparator.comparing(
                PageSample::getLastAccess, Comparator.nullsFirst(Comparator.naturalOrder())
        ).reversed();
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class ContentAttrSample {
        public static final TypeReference<List<ContentAttrSample>> LIST_REFERENCE = new TypeReference<>() {
        };
        @JsonProperty("Value")
        String value;
        @JsonProperty("Count")
        Long count;
        @JsonProperty("PageSamples")
        List<PageSample> pageSamples;

        public static final Comparator<ContentAttrSample> BY_COUNT_DESC = Comparator.comparing(
                ContentAttrSample::getCount, Comparator.nullsFirst(Comparator.naturalOrder())
        ).reversed();
    }

}
